/*
 * This declarations of the PIC16C782 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2012.
 *
 * This file is generated automatically by the cinc2h.pl, 2012-11-01 17:29:54 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16C782_H__
#define __PIC16C782_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF_ADDR               0x0000
#define TMR0_ADDR               0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR_ADDR                0x0004
#define PORTA_ADDR              0x0005
#define PORTB_ADDR              0x0006
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PIR1_ADDR               0x000C
#define TMR1_ADDR               0x000E
#define TMR1L_ADDR              0x000E
#define TMR1H_ADDR              0x000F
#define T1CON_ADDR              0x0010
#define ADRES_ADDR              0x001E
#define ADCON0_ADDR             0x001F
#define OPTION_REG_ADDR         0x0081
#define TRISA_ADDR              0x0085
#define TRISB_ADDR              0x0086
#define PIE1_ADDR               0x008C
#define PCON_ADDR               0x008E
#define WPUB_ADDR               0x0095
#define IOCB_ADDR               0x0096
#define REFCON_ADDR             0x009B
#define LVDCON_ADDR             0x009C
#define ANSEL_ADDR              0x009D
#define ADCON1_ADDR             0x009F
#define PMDATL_ADDR             0x010C
#define PMADRL_ADDR             0x010D
#define PMDATH_ADDR             0x010E
#define PMADRH_ADDR             0x010F
#define CALCON_ADDR             0x0110
#define PSMCCON0_ADDR           0x0111
#define PSMCCON1_ADDR           0x0112
#define CM1CON0_ADDR            0x0119
#define CM2CON0_ADDR            0x011A
#define CM2CON1_ADDR            0x011B
#define OPACON_ADDR             0x011C
#define DAC_ADDR                0x011E
#define DACON0_ADDR             0x011F
#define PMCON1_ADDR             0x018C

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF;
extern __at(0x0001) __sfr TMR0;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef union
  {
  struct
    {
    unsigned C                  : 1;
    unsigned DC                 : 1;
    unsigned Z                  : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned RP0                : 1;
    unsigned RP1                : 1;
    unsigned IRP                : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RP                 : 2;
    unsigned                    : 1;
    };
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10
#define _RP0                    0x20
#define _RP1                    0x40
#define _IRP                    0x80

//==============================================================================

extern __at(0x0004) __sfr FSR;

//==============================================================================
//        PORTA Bits

extern __at(0x0005) __sfr PORTA;

typedef struct
  {
  unsigned RA0                  : 1;
  unsigned RA1                  : 1;
  unsigned RA2                  : 1;
  unsigned RA3                  : 1;
  unsigned RA4                  : 1;
  unsigned RA5                  : 1;
  unsigned RA6                  : 1;
  unsigned RA7                  : 1;
  } __PORTAbits_t;

extern __at(0x0005) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20
#define _RA6                    0x40
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0006) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x0006) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================

extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef struct
  {
  unsigned RBIF                 : 1;
  unsigned INTF                 : 1;
  unsigned T0IF                 : 1;
  unsigned RBIE                 : 1;
  unsigned INTE                 : 1;
  unsigned T0IE                 : 1;
  unsigned PEIE                 : 1;
  unsigned GIE                  : 1;
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INTF                   0x02
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INTE                   0x10
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x000C) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned ADIF                 : 1;
  unsigned LVDIF                : 1;
  } __PIR1bits_t;

extern __at(0x000C) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _C1IF                   0x10
#define _C2IF                   0x20
#define _ADIF                   0x40
#define _LVDIF                  0x80

//==============================================================================

extern __at(0x000E) __sfr TMR1;
extern __at(0x000E) __sfr TMR1L;
extern __at(0x000F) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0010) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1GE             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1INSYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0010) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1INSYNC               0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1GE                 0x40

//==============================================================================

extern __at(0x001E) __sfr ADRES;

//==============================================================================
//        ADCON0 Bits

extern __at(0x001F) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned CHS3               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned ADCS               : 2;
    };
  } __ADCON0bits_t;

extern __at(0x001F) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _CHS3                   0x02
#define _GO_NOT_DONE            0x04
#define _GO                     0x04
#define _NOT_DONE               0x04
#define _GO_DONE                0x04
#define _CHS0                   0x08
#define _CHS1                   0x10
#define _CHS2                   0x20
#define _ADCS0                  0x40
#define _ADCS1                  0x80

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0081) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0081) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_RBPU               0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0085) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x0085) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0086) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x0086) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x008C) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned ADIE                 : 1;
  unsigned LVDIE                : 1;
  } __PIE1bits_t;

extern __at(0x008C) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _C1IE                   0x10
#define _C2IE                   0x20
#define _ADIE                   0x40
#define _LVDIE                  0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x008E) __sfr PCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned                    : 1;
    unsigned OSCF               : 1;
    unsigned WDTON              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NOT_BO             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PCONbits_t;

extern __at(0x008E) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_BO                 0x01
#define _NOT_POR                0x02
#define _OSCF                   0x08
#define _WDTON                  0x10

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x0095) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x0095) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        IOCB Bits

extern __at(0x0096) __sfr IOCB;

typedef struct
  {
  unsigned IOCB0                : 1;
  unsigned IOCB1                : 1;
  unsigned IOCB2                : 1;
  unsigned IOCB3                : 1;
  unsigned IOCB4                : 1;
  unsigned IOCB5                : 1;
  unsigned IOCB6                : 1;
  unsigned IOCB7                : 1;
  } __IOCBbits_t;

extern __at(0x0096) volatile __IOCBbits_t IOCBbits;

#define _IOCB0                  0x01
#define _IOCB1                  0x02
#define _IOCB2                  0x04
#define _IOCB3                  0x08
#define _IOCB4                  0x10
#define _IOCB5                  0x20
#define _IOCB6                  0x40
#define _IOCB7                  0x80

//==============================================================================


//==============================================================================
//        REFCON Bits

extern __at(0x009B) __sfr REFCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VROE               : 1;
    unsigned VREN               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VREFOE             : 1;
    unsigned VREFEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __REFCONbits_t;

extern __at(0x009B) volatile __REFCONbits_t REFCONbits;

#define _VROE                   0x04
#define _VREFOE                 0x04
#define _VREN                   0x08
#define _VREFEN                 0x08

//==============================================================================


//==============================================================================
//        LVDCON Bits

extern __at(0x009C) __sfr LVDCON;

typedef union
  {
  struct
    {
    unsigned LV0                : 1;
    unsigned LV1                : 1;
    unsigned LV2                : 1;
    unsigned LV3                : 1;
    unsigned LVDEN              : 1;
    unsigned BGST               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LV                 : 4;
    unsigned                    : 4;
    };
  } __LVDCONbits_t;

extern __at(0x009C) volatile __LVDCONbits_t LVDCONbits;

#define _LV0                    0x01
#define _LV1                    0x02
#define _LV2                    0x04
#define _LV3                    0x08
#define _LVDEN                  0x10
#define _BGST                   0x20

//==============================================================================


//==============================================================================
//        ANSEL Bits

extern __at(0x009D) __sfr ANSEL;

typedef struct
  {
  unsigned ANS0                 : 1;
  unsigned ANS1                 : 1;
  unsigned ANS2                 : 1;
  unsigned ANS3                 : 1;
  unsigned ANS4                 : 1;
  unsigned ANS5                 : 1;
  unsigned ANS6                 : 1;
  unsigned ANS7                 : 1;
  } __ANSELbits_t;

extern __at(0x009D) volatile __ANSELbits_t ANSELbits;

#define _ANS0                   0x01
#define _ANS1                   0x02
#define _ANS2                   0x04
#define _ANS3                   0x08
#define _ANS4                   0x10
#define _ANS5                   0x20
#define _ANS6                   0x40
#define _ANS7                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009F) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VCFG0              : 1;
    unsigned VCFG1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned VCFG               : 2;
    unsigned                    : 2;
    };
  } __ADCON1bits_t;

extern __at(0x009F) volatile __ADCON1bits_t ADCON1bits;

#define _VCFG0                  0x10
#define _VCFG1                  0x20

//==============================================================================

extern __at(0x010C) __sfr PMDATL;
extern __at(0x010D) __sfr PMADRL;
extern __at(0x010E) __sfr PMDATH;
extern __at(0x010F) __sfr PMADRH;

//==============================================================================
//        CALCON Bits

extern __at(0x0110) __sfr CALCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CALREF               : 1;
  unsigned CALERR               : 1;
  unsigned CAL                  : 1;
  } __CALCONbits_t;

extern __at(0x0110) volatile __CALCONbits_t CALCONbits;

#define _CALREF                 0x20
#define _CALERR                 0x40
#define _CAL                    0x80

//==============================================================================


//==============================================================================
//        PSMCCON0 Bits

extern __at(0x0111) __sfr PSMCCON0;

typedef union
  {
  struct
    {
    unsigned DC0                : 1;
    unsigned DC1                : 1;
    unsigned MAXDC0             : 1;
    unsigned MAXDC1             : 1;
    unsigned MINDC0             : 1;
    unsigned MINDC1             : 1;
    unsigned SMCCL0             : 1;
    unsigned SMCCL1             : 1;
    };

  struct
    {
    unsigned DC                 : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned MAXDC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned MINDC              : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned SMCCL              : 2;
    };
  } __PSMCCON0bits_t;

extern __at(0x0111) volatile __PSMCCON0bits_t PSMCCON0bits;

#define _DC0                    0x01
#define _DC1                    0x02
#define _MAXDC0                 0x04
#define _MAXDC1                 0x08
#define _MINDC0                 0x10
#define _MINDC1                 0x20
#define _SMCCL0                 0x40
#define _SMCCL1                 0x80

//==============================================================================


//==============================================================================
//        PSMCCON1 Bits

extern __at(0x0112) __sfr PSMCCON1;

typedef union
  {
  struct
    {
    unsigned SMCCS              : 1;
    unsigned PWM_NOT_PSM        : 1;
    unsigned SMCOM              : 1;
    unsigned SCEN               : 1;
    unsigned                    : 1;
    unsigned S1BPOL             : 1;
    unsigned S1APOL             : 1;
    unsigned SMCON              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned PWM                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned PSM                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_PSM            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PSMCCON1bits_t;

extern __at(0x0112) volatile __PSMCCON1bits_t PSMCCON1bits;

#define _SMCCS                  0x01
#define _PWM_NOT_PSM            0x02
#define _PWM                    0x02
#define _PSM                    0x02
#define _NOT_PSM                0x02
#define _SMCOM                  0x04
#define _SCEN                   0x08
#define _S1BPOL                 0x20
#define _S1APOL                 0x40
#define _SMCON                  0x80

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0119) __sfr CM1CON0;

typedef union
  {
  struct
    {
    unsigned C1CH0              : 1;
    unsigned C1CH1              : 1;
    unsigned C1R                : 1;
    unsigned C1SP               : 1;
    unsigned C1POL              : 1;
    unsigned C1OE               : 1;
    unsigned C1OUT              : 1;
    unsigned C1ON               : 1;
    };

  struct
    {
    unsigned C1CH               : 2;
    unsigned                    : 6;
    };
  } __CM1CON0bits_t;

extern __at(0x0119) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1CH0                  0x01
#define _C1CH1                  0x02
#define _C1R                    0x04
#define _C1SP                   0x08
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x011A) __sfr CM2CON0;

typedef union
  {
  struct
    {
    unsigned C2CH0              : 1;
    unsigned C2CH1              : 1;
    unsigned C2R                : 1;
    unsigned C2SP               : 1;
    unsigned C2POL              : 1;
    unsigned C2OE               : 1;
    unsigned C2OUT              : 1;
    unsigned C2ON               : 1;
    };

  struct
    {
    unsigned C2CH               : 2;
    unsigned                    : 6;
    };
  } __CM2CON0bits_t;

extern __at(0x011A) volatile __CM2CON0bits_t CM2CON0bits;

#define _C2CH0                  0x01
#define _C2CH1                  0x02
#define _C2R                    0x04
#define _C2SP                   0x08
#define _C2POL                  0x10
#define _C2OE                   0x20
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x011B) __sfr CM2CON1;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned MC2OUT               : 1;
  unsigned MC1OUT               : 1;
  } __CM2CON1bits_t;

extern __at(0x011B) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2SYNC                 0x01
#define _MC2OUT                 0x40
#define _MC1OUT                 0x80

//==============================================================================


//==============================================================================
//        OPACON Bits

extern __at(0x011C) __sfr OPACON;

typedef struct
  {
  unsigned GBWP                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CMPEN                : 1;
  unsigned OPAON                : 1;
  } __OPACONbits_t;

extern __at(0x011C) volatile __OPACONbits_t OPACONbits;

#define _GBWP                   0x01
#define _CMPEN                  0x40
#define _OPAON                  0x80

//==============================================================================


//==============================================================================
//        DAC Bits

extern __at(0x011E) __sfr DAC;

typedef struct
  {
  unsigned DA0                  : 1;
  unsigned DA1                  : 1;
  unsigned DA2                  : 1;
  unsigned DA3                  : 1;
  unsigned DA4                  : 1;
  unsigned DA5                  : 1;
  unsigned DA6                  : 1;
  unsigned DA7                  : 1;
  } __DACbits_t;

extern __at(0x011E) volatile __DACbits_t DACbits;

#define _DA0                    0x01
#define _DA1                    0x02
#define _DA2                    0x04
#define _DA3                    0x08
#define _DA4                    0x10
#define _DA5                    0x20
#define _DA6                    0x40
#define _DA7                    0x80

//==============================================================================


//==============================================================================
//        DACON0 Bits

extern __at(0x011F) __sfr DACON0;

typedef union
  {
  struct
    {
    unsigned DARS0              : 1;
    unsigned DARS1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DAOE               : 1;
    unsigned DAON               : 1;
    };

  struct
    {
    unsigned DARS               : 2;
    unsigned                    : 6;
    };
  } __DACON0bits_t;

extern __at(0x011F) volatile __DACON0bits_t DACON0bits;

#define _DARS0                  0x01
#define _DARS1                  0x02
#define _DAOE                   0x40
#define _DAON                   0x80

//==============================================================================


//==============================================================================
//        PMCON1 Bits

extern __at(0x018C) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x018C) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01

//==============================================================================


//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x2007

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_LP                0x3FF8  // LP oscillator.
#define _LP_OSC                 0x3FF8  // LP oscillator.
#define _FOSC_XT                0x3FF9  // XT oscillator.
#define _XT_OSC                 0x3FF9  // XT oscillator.
#define _FOSC_HS                0x3FFA  // HS oscillator.
#define _HS_OSC                 0x3FFA  // HS oscillator.
#define _FOSC_EXTCLK            0x3FFB  // EC I/O.
#define _EXTCLK_OSC             0x3FFB  // EC I/O.
#define _FOSC_INTRCIO           0x3FFC  // INTRC, OSC2 is I/O.
#define _INTRC_OSC_NOCLKOUT     0x3FFC  // INTRC, OSC2 is I/O.
#define _FOSC_INTRCCLK          0x3FFD  // INTRC, clockout on OSC2.
#define _INTRC_OSC_CLKOUT       0x3FFD  // INTRC, clockout on OSC2.
#define _FOSC_ER_NOCLKOUT       0x3FFE  // RC I/O.
#define _ER_OSC_NOCLKOUT        0x3FFE  // RC I/O.
#define _FOSC_ER_CLKOUT         0x3FFF  // RC CLKOUT.
#define _ER_OSC_CLKOUT          0x3FFF  // RC CLKOUT.
#define _WDTE_OFF               0x3FF7  // WDT disabled.
#define _WDT_OFF                0x3FF7  // WDT disabled.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _WDT_ON                 0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FEF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FDF  // Internal.
#define _MCLRE_ON               0x3FFF  // External.
#define _BOREN_OFF              0x3FBF  // BOR disabled.
#define _BODEN_OFF              0x3FBF  // BOR disabled.
#define _BOREN_ON               0x3FFF  // BOR enabled.
#define _BODEN_ON               0x3FFF  // BOR enabled.
#define _CP_ALL                 0x0CFF  // All memory is code protected.
#define _CP_OFF                 0x3FFF  // Code protection off.
#define _BODENV_45              0x33FF  // VBOR set to 4.5V.
#define _VBOR_45                0x33FF  // VBOR set to 4.5V.
#define _BODENV_42              0x37FF  // VBOR set to 4.2V.
#define _VBOR_42                0x37FF  // VBOR set to 4.2V.
#define _BODENV_27              0x3BFF  // VBOR set to 2.7V.
#define _VBOR_27                0x3BFF  // VBOR set to 2.7V.
#define _BODENV_25              0x3FFF  // VBOR set to 2.5V.
#define _VBOR_25                0x3FFF  // VBOR set to 2.5V.

//==============================================================================

#define _IDLOC0                 0x2000
#define _IDLOC1                 0x2001
#define _IDLOC2                 0x2002
#define _IDLOC3                 0x2003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define CHS3                    ADCON0bits.CHS3                 // bit 1
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 2, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 2, shadows bit in ADCON0bits
#define NOT_DONE                ADCON0bits.NOT_DONE             // bit 2, shadows bit in ADCON0bits
#define GO_DONE                 ADCON0bits.GO_DONE              // bit 2, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 3
#define CHS1                    ADCON0bits.CHS1                 // bit 4
#define CHS2                    ADCON0bits.CHS2                 // bit 5
#define ADCS0                   ADCON0bits.ADCS0                // bit 6
#define ADCS1                   ADCON0bits.ADCS1                // bit 7

#define VCFG0                   ADCON1bits.VCFG0                // bit 4
#define VCFG1                   ADCON1bits.VCFG1                // bit 5

#define ANS0                    ANSELbits.ANS0                  // bit 0
#define ANS1                    ANSELbits.ANS1                  // bit 1
#define ANS2                    ANSELbits.ANS2                  // bit 2
#define ANS3                    ANSELbits.ANS3                  // bit 3
#define ANS4                    ANSELbits.ANS4                  // bit 4
#define ANS5                    ANSELbits.ANS5                  // bit 5
#define ANS6                    ANSELbits.ANS6                  // bit 6
#define ANS7                    ANSELbits.ANS7                  // bit 7

#define CALREF                  CALCONbits.CALREF               // bit 5
#define CALERR                  CALCONbits.CALERR               // bit 6
#define CAL                     CALCONbits.CAL                  // bit 7

#define C1CH0                   CM1CON0bits.C1CH0               // bit 0
#define C1CH1                   CM1CON0bits.C1CH1               // bit 1
#define C1R                     CM1CON0bits.C1R                 // bit 2
#define C1SP                    CM1CON0bits.C1SP                // bit 3
#define C1POL                   CM1CON0bits.C1POL               // bit 4
#define C1OE                    CM1CON0bits.C1OE                // bit 5
#define C1OUT                   CM1CON0bits.C1OUT               // bit 6
#define C1ON                    CM1CON0bits.C1ON                // bit 7

#define C2CH0                   CM2CON0bits.C2CH0               // bit 0
#define C2CH1                   CM2CON0bits.C2CH1               // bit 1
#define C2R                     CM2CON0bits.C2R                 // bit 2
#define C2SP                    CM2CON0bits.C2SP                // bit 3
#define C2POL                   CM2CON0bits.C2POL               // bit 4
#define C2OE                    CM2CON0bits.C2OE                // bit 5
#define C2OUT                   CM2CON0bits.C2OUT               // bit 6
#define C2ON                    CM2CON0bits.C2ON                // bit 7

#define C2SYNC                  CM2CON1bits.C2SYNC              // bit 0
#define MC2OUT                  CM2CON1bits.MC2OUT              // bit 6
#define MC1OUT                  CM2CON1bits.MC1OUT              // bit 7

#define DA0                     DACbits.DA0                     // bit 0
#define DA1                     DACbits.DA1                     // bit 1
#define DA2                     DACbits.DA2                     // bit 2
#define DA3                     DACbits.DA3                     // bit 3
#define DA4                     DACbits.DA4                     // bit 4
#define DA5                     DACbits.DA5                     // bit 5
#define DA6                     DACbits.DA6                     // bit 6
#define DA7                     DACbits.DA7                     // bit 7

#define DARS0                   DACON0bits.DARS0                // bit 0
#define DARS1                   DACON0bits.DARS1                // bit 1
#define DAOE                    DACON0bits.DAOE                 // bit 6
#define DAON                    DACON0bits.DAON                 // bit 7

#define RBIF                    INTCONbits.RBIF                 // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define T0IF                    INTCONbits.T0IF                 // bit 2
#define RBIE                    INTCONbits.RBIE                 // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define T0IE                    INTCONbits.T0IE                 // bit 5
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCB0                   IOCBbits.IOCB0                  // bit 0
#define IOCB1                   IOCBbits.IOCB1                  // bit 1
#define IOCB2                   IOCBbits.IOCB2                  // bit 2
#define IOCB3                   IOCBbits.IOCB3                  // bit 3
#define IOCB4                   IOCBbits.IOCB4                  // bit 4
#define IOCB5                   IOCBbits.IOCB5                  // bit 5
#define IOCB6                   IOCBbits.IOCB6                  // bit 6
#define IOCB7                   IOCBbits.IOCB7                  // bit 7

#define LV0                     LVDCONbits.LV0                  // bit 0
#define LV1                     LVDCONbits.LV1                  // bit 1
#define LV2                     LVDCONbits.LV2                  // bit 2
#define LV3                     LVDCONbits.LV3                  // bit 3
#define LVDEN                   LVDCONbits.LVDEN                // bit 4
#define BGST                    LVDCONbits.BGST                 // bit 5

#define GBWP                    OPACONbits.GBWP                 // bit 0
#define CMPEN                   OPACONbits.CMPEN                // bit 6
#define OPAON                   OPACONbits.OPAON                // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define T0SE                    OPTION_REGbits.T0SE             // bit 4
#define T0CS                    OPTION_REGbits.T0CS             // bit 5
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_RBPU                OPTION_REGbits.NOT_RBPU         // bit 7

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0, shadows bit in PCONbits
#define NOT_BO                  PCONbits.NOT_BO                 // bit 0, shadows bit in PCONbits
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define OSCF                    PCONbits.OSCF                   // bit 3
#define WDTON                   PCONbits.WDTON                  // bit 4

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define C1IE                    PIE1bits.C1IE                   // bit 4
#define C2IE                    PIE1bits.C2IE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define LVDIE                   PIE1bits.LVDIE                  // bit 7

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define C1IF                    PIR1bits.C1IF                   // bit 4
#define C2IF                    PIR1bits.C2IF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define LVDIF                   PIR1bits.LVDIF                  // bit 7

#define RD                      PMCON1bits.RD                   // bit 0

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5
#define RA6                     PORTAbits.RA6                   // bit 6
#define RA7                     PORTAbits.RA7                   // bit 7

#define RB0                     PORTBbits.RB0                   // bit 0
#define RB1                     PORTBbits.RB1                   // bit 1
#define RB2                     PORTBbits.RB2                   // bit 2
#define RB3                     PORTBbits.RB3                   // bit 3
#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define DC0                     PSMCCON0bits.DC0                // bit 0
#define DC1                     PSMCCON0bits.DC1                // bit 1
#define MAXDC0                  PSMCCON0bits.MAXDC0             // bit 2
#define MAXDC1                  PSMCCON0bits.MAXDC1             // bit 3
#define MINDC0                  PSMCCON0bits.MINDC0             // bit 4
#define MINDC1                  PSMCCON0bits.MINDC1             // bit 5
#define SMCCL0                  PSMCCON0bits.SMCCL0             // bit 6
#define SMCCL1                  PSMCCON0bits.SMCCL1             // bit 7

#define SMCCS                   PSMCCON1bits.SMCCS              // bit 0
#define PWM_NOT_PSM             PSMCCON1bits.PWM_NOT_PSM        // bit 1, shadows bit in PSMCCON1bits
#define PWM                     PSMCCON1bits.PWM                // bit 1, shadows bit in PSMCCON1bits
#define PSM                     PSMCCON1bits.PSM                // bit 1, shadows bit in PSMCCON1bits
#define NOT_PSM                 PSMCCON1bits.NOT_PSM            // bit 1, shadows bit in PSMCCON1bits
#define SMCOM                   PSMCCON1bits.SMCOM              // bit 2
#define SCEN                    PSMCCON1bits.SCEN               // bit 3
#define S1BPOL                  PSMCCON1bits.S1BPOL             // bit 5
#define S1APOL                  PSMCCON1bits.S1APOL             // bit 6
#define SMCON                   PSMCCON1bits.SMCON              // bit 7

#define VROE                    REFCONbits.VROE                 // bit 2, shadows bit in REFCONbits
#define VREFOE                  REFCONbits.VREFOE               // bit 2, shadows bit in REFCONbits
#define VREN                    REFCONbits.VREN                 // bit 3, shadows bit in REFCONbits
#define VREFEN                  REFCONbits.VREFEN               // bit 3, shadows bit in REFCONbits

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4
#define RP0                     STATUSbits.RP0                  // bit 5
#define RP1                     STATUSbits.RP1                  // bit 6
#define IRP                     STATUSbits.IRP                  // bit 7

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define TMR1CS                  T1CONbits.TMR1CS                // bit 1
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2, shadows bit in T1CONbits
#define T1INSYNC                T1CONbits.T1INSYNC              // bit 2, shadows bit in T1CONbits
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1GE                  T1CONbits.TMR1GE                // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5
#define TRISA6                  TRISAbits.TRISA6                // bit 6
#define TRISA7                  TRISAbits.TRISA7                // bit 7

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define WPUB0                   WPUBbits.WPUB0                  // bit 0
#define WPUB1                   WPUBbits.WPUB1                  // bit 1
#define WPUB2                   WPUBbits.WPUB2                  // bit 2
#define WPUB3                   WPUBbits.WPUB3                  // bit 3
#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16C782_H__
